<?php

/**
 * Plugin Name: Faces & Voices of Recovery: Image Receiver
 * Description: Exposes an AJAX endpoint to receive images from the Image Distributor Plugin.
 */

if (!defined('ABSPATH')) exit;

class ReceiverPlugin
{

    private $encryption_key = 'lsQ#/}A21Q<7£$s//'; // Must match the key used in the distributor plugin


    public function __construct()
    {
        add_action('wp_ajax_nopriv_receiver_upload_image', [$this, 'upload_image']);
        add_action('wp_ajax_receiver_upload_image', [$this, 'upload_image']);
        add_action('init', [$this, 'allow_cors']);
    }

    public function allow_cors()
    {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
        header("Access-Control-Allow-Headers: Content-Type, Authorization");
    }

    public function upload_image()
    {


        $tokenStat = $this->verify_token($_POST['token']);

        // Check if the token is provided and valid
        if ($tokenStat !== true) {
            wp_send_json_error(['message' => $tokenStat]);
            return;
        }


        // Check if the file is received in the 'image' key in $_FILES
        if (empty($_FILES['image']) || $_FILES['image']['error'] !== UPLOAD_ERR_OK) {
            wp_send_json_error(['message' => 'No image data received or upload error']);
        }

        $file = $_FILES['image'];
        $allowed_types = ['image/jpeg', 'image/png'];
        $mime_type = mime_content_type($file['tmp_name']);

        // Validate the image type
        if (!in_array($mime_type, $allowed_types)) {
            wp_send_json_error(['message' => 'Invalid image format. Only JPG, JPEG, and PNG are accepted.']);
        }

        // Determine file extension based on MIME type
        $extension = ($mime_type === 'image/png') ? 'png' : 'jpg';

        $upload_dir = wp_upload_dir();
        $file_name = 'transmitted_image_' . time() . '.' . $extension;
        $file_path = $upload_dir['path'] . '/' . $file_name;

        // Move the uploaded file to the final destination
        if (move_uploaded_file($file['tmp_name'], $file_path)) {
            $attachment_id = wp_insert_attachment([
                'guid' => $upload_dir['url'] . '/' . $file_name,
                'post_mime_type' => $mime_type,
                'post_title' => sanitize_file_name($file_name),
                'post_content' => '',
                'post_status' => 'inherit'
            ], $file_path);

            if (!is_wp_error($attachment_id)) {
                require_once(ABSPATH . 'wp-admin/includes/image.php');
                wp_update_attachment_metadata($attachment_id, wp_generate_attachment_metadata($attachment_id, $file_path));
                wp_send_json_success(['message' => 'Image uploaded successfully']);
            }
        }

        wp_send_json_error(['message' => 'Image upload failed']);
    }


    private function verify_token($token)
{
    if (empty($token)) {
        return "Token is missing"; // Token is missing
    }

    if (!extension_loaded('openssl')) {
        return "OpenSSL extension is required"; // OpenSSL extension is required
    }


    $decodedData = base64_decode($token);

    list($encrypted_data, $iv) = explode('~~', $decodedData, 2);

    $decrypted = openssl_decrypt($encrypted_data, 'aes-256-cbc', $this->encryption_key, 0, $iv);

    if ($decrypted === false) {
        return "Invalid encryption key"; // Invalid encryption key
    }


    $data = json_decode($decrypted, true);
    if (!isset($data['expiry']) || time() > $data['expiry']) {
        return "Token is expired"; // Token is expired
    }

    return true;
}

}


new ReceiverPlugin();
