<?php

/**
 * Plugin Name: Faces & Voices of Recovery: Image Distributor
 * Description: Allows the admin to manage receiver websites and upload images to them.
 */

if (!defined('ABSPATH')) exit;

class ImageDistributorPlugin
{

    private $encryption_key = 'lsQ#/}A21Q<7£$s//';


    public function __construct()
    {
        add_action('admin_menu', [$this, 'add_admin_menu']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_assets']);
        add_action('wp_ajax_save_websites', [$this, 'save_websites']);
    }

    public function add_admin_menu()
    {
        add_menu_page(
            'Image Distributor Settings',
            'Image Distributor',
            'manage_options',
            'image_distributor_plugin',
            [$this, 'settings_page'],
            'dashicons-networking'
        );
    }

    public function enqueue_assets()
    {

        // Enqueue the CSS file
        wp_enqueue_style('image-distributor-style', plugin_dir_url(__FILE__) . 'css/style.css', [], '1.0');

        // Enqueue the JavaScript file
        wp_enqueue_script('distributor-admin', plugin_dir_url(__FILE__) . 'js/distributor-admin.js', ['jquery'], '1.0', true);

        // Localize the script to pass data from PHP to JavaScript
        wp_localize_script('distributor-admin', 'distributorData', [
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('distributor_nonce'),
            'secureToken' => $this->generate_secure_token()
        ]);
    }

    public function settings_page()
    {
        $receiver_websites = get_option('image_distributor_receiver_websites', []);
?>
        <div class="wrap">

            <h1>Image Distributor Settings</h1>
            <form id="distributor-form">

                <div class="disrp_settings_w">

                    <!-- Receiver Websites Table -->
                    <h2>Receiver Websites</h2>
                    <table id="receiver-website-table" class="styled-table">
                        <thead>
                            <tr>
                                <th>Website URL</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody id="receiver-website-inputs">
                            <?php foreach ($receiver_websites as $index => $url): ?>
                                <tr class="website-entry" data-index="<?php echo esc_attr($index); ?>">
                                    <td>
                                        <input type="text" class="receiver-website" value="<?php echo esc_attr($url); ?>" style="width: 100%;" />
                                    </td>
                                    <td>
                                        <button type="button" class="delete-website">Delete</button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <div class="buttons_w">
                        <button type="button" id="add-website" style="margin-top: 10px;">Add Website</button>
                        <button type="button" id="save-websites" style="margin-top: 10px;">Save Websites</button>
                    </div>

                </div>


                <div class="disrp_settings_upload_w">

                    <!-- Image Upload Section -->
                    <h2>Upload Image to All Receivers Websites</h2>
                    <div class="buttons_w">
                        <input type="file" id="image-upload" accept="image/*" style="margin-top: 10px;">
                        <button type="button" id="upload-image" style="margin-top: 10px;">Upload to All Sites</button>
                    </div>

                    <!-- Upload Progress Table -->
                    <h3 style="margin-top: 39px;border-top: 1px solid gray;padding-top: 20px;">Upload Progress</h3>
                    <table id="upload-progress-table" class="styled-table">
                        <thead>
                            <tr>
                                <th>Website</th>
                                <th>Status</th>
                                <th>Retry</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>

                </div>
            </form>
        </div>
<?php
    }


    public function save_websites()
    {
        check_ajax_referer('distributor_nonce', 'nonce');

        if (isset($_POST['websites'])) {
            update_option('image_distributor_receiver_websites', $_POST['websites']);
            wp_send_json_success(['message' => 'Websites saved successfully']);
        }

        wp_send_json_error(['message' => 'Failed to save websites']);
    }


    private function generate_secure_token()
    {
        $expiry_time = time() + (2 * 60 * 60); // 2 hours from now
        $data = [
            'expiry' => $expiry_time
        ];
        $plaintext = json_encode($data);
    
        if (!extension_loaded('openssl')) {
            return false; // OpenSSL extension is required
        }

        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length('aes-256-cbc'));
        $encrypted_data = openssl_encrypt($plaintext, 'aes-256-cbc', $this->encryption_key, 0, $iv);

        $encoded = base64_encode($encrypted_data . '~~' . $iv);
       
        return $encoded;
    
    }
}

new ImageDistributorPlugin();
