jQuery(document).ready(function($) {
    const $inputs = $('#receiver-website-inputs');  // Receiver websites table body
    const $progressTable = $('#upload-progress-table tbody');  // Upload progress table body

    // Add a new receiver website entry
    $('#add-website').on('click', function() {
        const index = $inputs.children().length;
        $inputs.append(`
            <tr class="website-entry" data-index="${index}">
                <td>
                    <input type="text" class="receiver-website" placeholder="Enter Receiver URL" style="width: 100%;" />
                </td>
                <td>
                    <button type="button" class="delete-website">Delete</button>
                </td>
            </tr>
        `);
    });

    // Save all receiver websites
    $('#save-websites').on('click', function() {
        const websites = [];
        $('.receiver-website').each(function() {
            websites.push($(this).val());
        });

        $.post(distributorData.ajaxUrl, {
            action: 'save_websites',
            websites: websites,
            nonce: distributorData.nonce
        }, function(response) {
            if (response.success) {
                alert('Websites saved successfully');
            } else {
                alert('Failed to save websites');
            }
        });
    });

    // Delete a receiver website entry
    $inputs.on('click', '.delete-website', function() {
        $(this).closest('tr').remove();
    });

    // Upload image to all websites
    $('#upload-image').on('click', function() {
        const file = $('#image-upload')[0].files[0];
        if (!file) {
            alert('Please select an image');
            return;
        }

        const websites = [];
        $('.receiver-website').each(function() {
            websites.push($(this).val());
        });

        $progressTable.empty();  // Clear previous progress entries

        websites.forEach(website => {
            const row = $(`
                <tr>
                    <td>${website}</td>
                    <td class="status">Pending</td>
                    <td><button type="button" disabled class="retry-button" data-website="${website}">Retry</button></td>
                </tr>
            `);
            $progressTable.append(row);

            // Start upload for each website
            uploadToReceiver(website, file, row);
        });
    });

    // Function to handle image upload to receiver website
    function uploadToReceiver(website, file, row) {
        const formData = new FormData();
        formData.append('action', 'receiver_upload_image');
        formData.append('image', file);
        formData.append('token', distributorData.secureToken); // Include the secure token

        $.ajax({
            url: `${website}/wp-admin/admin-ajax.php`,
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
        
                if (response.success) {
                    row.find('.status').text('Success');
                    row.find('.retry-button').prop('disabled', true);  // Disable retry button on success
                } else {

                    try {
    
                        const error = response.data.message;
                        row.find('.status').text("Failed: " + error);
                    } catch (e) {
                     
                        row.find('.status').text("Failed: Unknown error");
                    }

                    row.find('.retry-button').prop('disabled', false);  // Enable retry button on failure
                }
            },
            error: function() {
                row.find('.status').text('Failed');
                row.find('.retry-button').prop('disabled', false);  // Enable retry button on error
            }
        });
    }

    // Retry button functionality
    $progressTable.on('click', '.retry-button', function() {
        const website = $(this).data('website');
        const row = $(this).closest('tr');
        // Change status to pending
        row.find('.status').text('Pending');
        // Disable retry button
        $(this).prop('disabled', true);
        // Retry upload
        const file = $('#image-upload')[0].files[0];
        uploadToReceiver(website, file, row);
    });
});
